<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RideRequest extends Model 
{

    protected $table = 'ride_requests';
    public $timestamps = true;

    public function ride()
    {
        return $this->belongsTo('Ride');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function paymentMethod()
    {
        return $this->hasOne('PaymentMethod');
    }

    public function status()
    {
        return $this->hasOne('Status');
    }

}